/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.function.Supplier;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.SuperBufferFactory;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import org.apache.commons.lang3.tuple.Pair;

public class CachedBuffers {
    public static final SuperByteBufferCache.Compartment<class_2680> GENERIC_BLOCK = new SuperByteBufferCache.Compartment();
    public static final SuperByteBufferCache.Compartment<PartialModel> PARTIAL = new SuperByteBufferCache.Compartment();
    public static final SuperByteBufferCache.Compartment<Pair<class_2350, PartialModel>> DIRECTIONAL_PARTIAL = new SuperByteBufferCache.Compartment();

    public static SuperByteBuffer block(class_2680 toRender) {
        return CachedBuffers.block(GENERIC_BLOCK, toRender);
    }

    public static SuperByteBuffer block(SuperByteBufferCache.Compartment<class_2680> compartment, class_2680 toRender) {
        return SuperByteBufferCache.getInstance().get(compartment, toRender, () -> SuperBufferFactory.getInstance().createForBlock(toRender));
    }

    public static SuperByteBuffer partial(PartialModel partial, class_2680 referenceState) {
        return SuperByteBufferCache.getInstance().get(PARTIAL, partial, () -> SuperBufferFactory.getInstance().createForBlock(partial.get(), referenceState));
    }

    public static SuperByteBuffer partial(PartialModel partial, class_2680 referenceState, Supplier<class_4587> modelTransform) {
        return SuperByteBufferCache.getInstance().get(PARTIAL, partial, () -> SuperBufferFactory.getInstance().createForBlock(partial.get(), referenceState, (class_4587)modelTransform.get()));
    }

    public static SuperByteBuffer partialFacing(PartialModel partial, class_2680 referenceState) {
        class_2350 facing = (class_2350)referenceState.method_11654((class_2769)class_2741.field_12525);
        return CachedBuffers.partialFacing(partial, referenceState, facing);
    }

    public static SuperByteBuffer partialFacing(PartialModel partial, class_2680 referenceState, class_2350 facing) {
        return CachedBuffers.partialDirectional(partial, referenceState, facing, CachedBuffers.rotateToFace(facing));
    }

    public static SuperByteBuffer partialFacingVertical(PartialModel partial, class_2680 referenceState, class_2350 facing) {
        return CachedBuffers.partialDirectional(partial, referenceState, facing, CachedBuffers.rotateToFaceVertical(facing));
    }

    public static SuperByteBuffer partialDirectional(PartialModel partial, class_2680 referenceState, class_2350 dir, Supplier<class_4587> modelTransform) {
        return SuperByteBufferCache.getInstance().get(DIRECTIONAL_PARTIAL, Pair.of((Object)dir, (Object)partial), () -> SuperBufferFactory.getInstance().createForBlock(partial.get(), referenceState, (class_4587)modelTransform.get()));
    }

    public static Supplier<class_4587> rotateToFace(class_2350 facing) {
        return () -> {
            class_4587 stack = new class_4587();
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)stack).center()).rotateYDegrees(AngleHelper.horizontalAngle(facing))).rotateXDegrees(AngleHelper.verticalAngle(facing))).uncenter();
            return stack;
        };
    }

    public static Supplier<class_4587> rotateToFaceVertical(class_2350 facing) {
        return () -> {
            class_4587 stack = new class_4587();
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((class_4587)stack).center()).rotateYDegrees(AngleHelper.horizontalAngle(facing))).rotateXDegrees(AngleHelper.verticalAngle(facing) + 90.0f)).uncenter();
            return stack;
        };
    }
}

